import streamlit as st
from openai import OpenAI

API_KEY = "api"
BASE_URL = "https://ospan3.tail37e5e0.ts.net/v1"
MODEL_NAME = "OpticsGPT-v1:latest"

client = OpenAI(
    api_key=API_KEY,
    base_url=BASE_URL,
)

st.title("Optics GPT")

if "messages" not in st.session_state:
    st.session_state.messages = []
    st.session_state.messages.append(
        {"role": "assistant", "content": "你好！我是 Optics GPT，请问有什么可以帮您？"})

# 显示聊天历史
for message in st.session_state.messages:
    with st.chat_message(message["role"]):
        st.markdown(message["content"])

# 聊天输入逻辑
if prompt := st.chat_input("请输入您的问题..."):
    st.session_state.messages.append({"role": "user", "content": prompt})
    with st.chat_message("user"):
        st.markdown(prompt)

    with st.chat_message("assistant"):
        message_placeholder = st.empty()
        full_response = ""

        try:
            stream = client.chat.completions.create(
                model=MODEL_NAME,
                messages=st.session_state.messages,
                stream=True,
            )


            for chunk in stream:
                delta = chunk.choices[0].delta.content
                if delta:
                    full_response += delta
                    message_placeholder.markdown(full_response + "▌")


            message_placeholder.markdown(full_response)

        except Exception as e:
            error_msg = f"调用API失败: {str(e)}"
            st.error(error_msg)
            full_response = error_msg

        st.session_state.messages.append({"role": "assistant", "content": full_response})